% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-genetic-dist.R
\name{plotGeneticDist}
\alias{plotGeneticDist}
\title{plotGeneticDist}
\usage{
plotGeneticDist(gr, bin = TRUE, chr = NULL, cumulative = FALSE)
}
\arguments{
\item{gr}{GRanges object with genetic distances calculated for marker
intervals}

\item{bin}{TRUE or FALSE, indicating whether the supplied GRange objecct
is for binned interval}

\item{chr}{the specific chrs selected to plot}

\item{cumulative}{TRUE or FALSE, indicating whether it plots the bin-wise
genetic distances or the cumulative distances}
}
\value{
ggplot2 plot
}
\description{
Plotting the calculated genetic distanced for each bin or marker interval
supplied by the GRanges object
}
\examples{
data(coCount)
dist_se <- calGeneticDist(coCount)
plotGeneticDist(SummarizedExperiment::rowRanges(dist_se))
}
\author{
Ruqian Lyu
}
