% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic-qc-checks.R
\name{perSegChrQC}
\alias{perSegChrQC}
\title{perSegChrQC}
\usage{
perSegChrQC(
  sampleName,
  chroms = c("chr1", "chr7", "chr15"),
  path,
  barcodeFile = NULL,
  maxRawCO = 10
)
}
\arguments{
\item{sampleName, }{the name of the sample to parse which is used as prefix
for finding relevant files for the underlying sample}

\item{chroms, }{the vector of chromosomes}

\item{path, }{the path to the files, with name patterns *{chrom}_vi.mtx,
*{chrom}_viSegInfo.txt, end with slash}

\item{barcodeFile, }{defaults to NULL, it is assumed to be in the same
directory as the other files and with name sampleName_barcodes.txt}

\item{maxRawCO, }{if a cell has more than `maxRawCO` number of raw crossovers
called across a chromosome, the cell is filtered out#'}
}
\value{
Histogram plots for statistics summarized across all Viterbi state
segments
}
\description{
Plots the summary statistics of segments that are generated by `sgcocaller`
\url{https://gitlab.svi.edu.au/biocellgen-public/sgcocaller}
which have been detected by finding consequtive viter states along the list
of SNP markers.
}
\details{
It provides guidance in filtering out close double crossovers that are not
likely biological but due to technical reasons as well as crossovers that are
supported by fewer number of SNPs at the ends of the chromosomes.
}
\examples{
demo_path <- system.file("extdata",package = "comapr")
s1_rse_qc <- perSegChrQC(sampleName="s1",
                            chroms=c("chr1"),
                            path=demo_path, maxRawCO=10)

}
\author{
Ruqian Lyu
}
