% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-af-tracks.R
\name{getAFTracks}
\alias{getAFTracks}
\title{getAFTracks}
\usage{
getAFTracks(
  chrom = "chr1",
  path_loc = "./output/firstBatch/WC_522/",
  sampleName = "WC_522",
  nwindow = 80,
  barcodeFile,
  co_count,
  snp_track = NULL
)
}
\arguments{
\item{chrom}{the chromosome}

\item{path_loc}{the path prefix to the output files from sscocaller including
"*_totalCount.mtx" and "_altCount.mtx"}

\item{sampleName}{the sample name, which is the prefix of sscocaller's output
files}

\item{nwindow}{the number of windows for binning the chromosome}

\item{barcodeFile}{the barcode file containing the list of cell barcodes used
as the input file for sscocaller}

\item{co_count}{`GRange` or `RangedSummarizedExperiment` object,
returned by \code{countCO} that contains the crossover intervals and the number
of crossovers in each cell.}

\item{snp_track}{the SNP position track which is used for obtaining the SNP
chromosome locations. It could be omitted and the SNP positions will be acquired
from the "*_snpAnnot.txt" file.}
}
\value{
a list object, in which each element is a list of two items with the
cell's alternative allele frequency DataTrack and the called crossover ranges.
}
\description{
Generate the raw alternative allele frequencies tracks for all cells in the
columns of provided `co_count`
}
\examples{
demo_path <- system.file("extdata",package = "comapr")
s1_rse_state <- readHapState("s1",chroms=c("chr1"),
                             path=demo_path,barcodeFile=NULL,minSNP = 0,
                             minlogllRatio = 50,
                             bpDist = 100,maxRawCO=10,
                             minCellSNP = 0)
s1_counts <- countCOs(s1_rse_state)

af_co_tracks <- getAFTracks(chrom ="chr1",
                               path_loc = demo_path,
                               sampleName = "s1",
                               barcodeFile = file.path(demo_path,
                                                    "s1_barcodes.txt"),
                               co_count = s1_counts)

}
\author{
Ruqian Lyu
}
