% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-dup-samples.R
\name{findDupSamples}
\alias{findDupSamples}
\title{findDupSamples}
\usage{
findDupSamples(geno, threshold = 0.99, in_text = FALSE)
}
\arguments{
\item{geno}{the genotype data.frame of markers by samples from output of
function \code{correctGT}}

\item{threshold}{the frequency cut-off of number of matching genotypes out of
all geneotypes for determining whether the pair of samples
are duplicated, defaults to \code{0.99}. NAs are regarded as same genotypes for
two samples if they both have NA for a marker.}

\item{in_text}{whether text of frequencies should be displayed in the
heatmap cells}
}
\value{
The paris of duplicated samples.
}
\description{
Find the duplicated samples by look at the number of matching genotypes
in all pair-wise samples
}
\examples{
data(snp_geno)
or_geno <- snp_geno[,grep("X",colnames(snp_geno))]
rownames(or_geno) <- paste0(snp_geno$CHR,"_",snp_geno$POS)
or_geno[,1] <- or_geno[,5]
cr_geno <- correctGT(or_geno,ref = snp_geno$C57BL.6J,
                    alt = snp_geno$FVB.NJ..i.)
dups <- findDupSamples(cr_geno)
}
\author{
Ruqian Lyu
}
