% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic-qc-checks.R
\name{countBinState}
\alias{countBinState}
\title{countBinState}
\usage{
countBinState(chr, snpAnno, viState, genomeRange, ntile = 5)
}
\arguments{
\item{chr, }{character, the chromosome to check}

\item{snpAnno, }{data.frame, the SNP annotation for the supplied chromosome}

\item{viState, }{dgTMatrix/Matrix, the viterbi state matrix, output from
`sgcocaller`}

\item{genomeRange, }{GRanges object with seqlengths information for the genome}

\item{ntile, }{integer, how many tiles the chromosome is binned into}
}
\value{
a data.frame that contains chromosome bin segregation ratio
}
\description{
Bins the chromosome into supplied number of bins and find the state of
the chromosome bins across all gamete cells
}
\details{
This function is used for checking whether chromosome segregation pattern
obeys the expected ratio.
}
\examples{
 
library(IRanges)
library(S4Vectors)

chrom_info <- GenomeInfoDb::getChromInfoFromUCSC("mm10")
seq_length <- chrom_info$size
names(seq_length) <- chrom_info$chrom

dna_mm10_gr <- GenomicRanges::GRanges(
  seqnames = Rle(names(seq_length)),
  ranges = IRanges(1, end = seq_length, names = names(seq_length)),
  seqlengths = seq_length)

GenomeInfoDb::genome(dna_mm10_gr) <- "mm10"
demo_path <- system.file("extdata",package = "comapr")
sampleName <- "s1"
chr <- "chr1"
vi_mtx <- Matrix::readMM(file = paste0(demo_path,"/", sampleName, "_",
                                       chr, "_vi.mtx"))

snpAnno <- read.table(file = paste0(demo_path,"/", sampleName,
                                    "_", chr, "_snpAnnot.txt"),
                                    stringsAsFactors = FALSE,
                      header = TRUE)

countBinState(chr = "chr1",snpAnno = snpAnno,
viState = vi_mtx,genomeRange = dna_mm10_gr, ntile = 1)

}
\author{
Ruqian Lyu
}
