% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reformat-geno-mt.R
\name{correctGT}
\alias{correctGT}
\title{correctGT}
\usage{
correctGT(gt_matrix, ref, alt, failed = "Fail", wrong_label = "Homo_ref")
}
\arguments{
\item{gt_matrix}{the input genotype matrix of markers by samples with rownames as marker IDs
and column names as sample IDs}

\item{ref}{a vector of genotypes of the inbred reference strain}

\item{alt}{a vector of genotypes of the inbred alternative strain}

\item{failed}{what was used for encoding failed genotype calling such as "Fail" in example
data \code{snp_geno}}

\item{wrong_label}{what would be considered a wrong genotype label for example Homo_ref which
should not be in the possible genotypes of BC1F1 samples}
}
\value{
a genotype data.frame of sample genotypes with dimension as the input
`gt_matrix` with genotypes converted to labels and failed calls are changed
to NA.
}
\description{
function for formatting and correction genotypes of markers
}
\details{
This function changes genotype in alleles to genotype labels, change Homo_ref
to Hets/Fail, infer Failed genotype, and change "Failed" to NA for
counting crossover later


This function changes genotype in alleles to labels by calling internal
functions \code{lable_gt}, and changes the wrong genotype Homo_ref to Fail by
calling \code{.change_missing}.
}
\examples{
data(snp_geno_gr)
data(parents_geno)
snp_gt_crt <- correctGT(gt_matrix = GenomicRanges::mcols(snp_geno_gr),
                      ref = parents_geno$ref,
                      alt = parents_geno$alt,
                      fail = "Fail",
                      wrong_label = "Homo_ref")
}
\author{
Ruqian Lyu
}
