% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrapDist}
\alias{bootstrapDist}
\title{bootstrapDist}
\usage{
bootstrapDist(co_gr, B = 1000, mapping_fun = "k", group_by)
}
\arguments{
\item{co_gr}{GRanges or RangedSummarizedExperiment object that contains the
crossover counts for each marker interval across all samples.
Returned by \code{countCOs}}

\item{B}{integer the number of sampling times}

\item{mapping_fun}{character default to "k" (kosambi mapping function). It
can be one of the mapping functions: "k","h"}

\item{group_by, }{the prefix for each group that we need to generate
distributions for(only when co_gr is a GRanges object). Or the column name
for `colData(co_gr)` that contains the
group factor (only when co_gr is a RangedSummarizedExperiment object)}
}
\value{
lists of numeric genetic distances for multiple samples
}
\description{
Generating distribution of sample genetic distances
}
\details{
It takes the crossover counts for samples in multiple groups that is returned
by `countCO`. It then draws samples from a group with replacement and
calculate the distribution of relevant statistics.
}
\examples{
data(coCount)

bootsDiff <- bootstrapDist(coCount, group_by = "sampleGroup",B=10)
}
\author{
Ruqian Lyu
}
