% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_species_tree}
\alias{plot_species_tree}
\title{Plot species tree}
\usage{
plot_species_tree(tree = NULL, xlim = c(0, 1), stats_list = NULL)
}
\arguments{
\item{tree}{Tree object as returned by \code{treeio::read.*},
a family of functions in the \strong{treeio} package to import tree files
in multiple formats, such as Newick, Phylip, NEXUS, and others.
If your species tree was inferred with Orthofinder (using STAG), the tree
file is located in \emph{Species_Tree/SpeciesTree_rooted_node_labels.txt}.
Then, it can be imported with \code{treeio::read_tree(path_to_file)}.}

\item{xlim}{Numeric vector of x-axis limits. This is useful if your
node tip labels are not visible due to margin issues. Default: c(0, 1).}

\item{stats_list}{(optional) A list of data frames with Orthofinder summary
stats as returned by the function \code{read_orthofinder_stats}. If this list
is given as input, nodes will be labeled with the number of duplications.}
}
\value{
A ggtree/ggplot object with the species tree.
}
\description{
Plot species tree
}
\examples{
data(tree)
plot_species_tree(tree)
}
