% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_og_sizes}
\alias{plot_og_sizes}
\title{Plot orthogroup sizes per species}
\usage{
plot_og_sizes(orthogroups = NULL, log = FALSE, max_size = NULL)
}
\arguments{
\item{orthogroups}{A 3-column data frame with columns \strong{Orthogroup},
\strong{Species}, and \strong{Gene}. This data frame can be created from
the 'Orthogroups.tsv' file generated by OrthoFinder with the function
\code{read_orthogroups()}.}

\item{log}{Logical indicating whether to transform orthogroups sizes with
natural logarithms. Default: FALSE.}

\item{max_size}{Numeric indicating the maximum orthogroup size to consider.
If this parameter is not NULL, orthogroups larger
than \code{max_size} (e.g., 100) will not be considered. Default: NULL.}
}
\value{
A ggplot object with a violin plot.
}
\description{
Plot orthogroup sizes per species
}
\examples{
data(og)
plot_og_sizes(og, log = TRUE)
plot_og_sizes(og, max_size = 100)
plot_og_sizes(og, log = TRUE, max_size = 100)
}
