% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upDownGene.R
\name{upDownGene}
\alias{upDownGene}
\alias{upDownGene,cogena-method}
\alias{upDownGene,cogena}
\alias{logfc}
\alias{logfc,}
\title{Show up or down-regualted genes for a clustering method and the number of clusters.}
\usage{
upDownGene(object, method, nCluster, add2 = FALSE)

\S4method{upDownGene}{cogena}(object, method, nCluster, add2 = FALSE)

logfc(dat, sampleLabel)
}
\arguments{
\item{object}{a genecl or cogena object}

\item{method}{as clMethods in genecl function}

\item{nCluster}{cluster number}

\item{add2}{add2 enrichment score for add Up and Down reuglated genes}

\item{dat}{gene expression data frame}

\item{sampleLabel}{factor. sampleLabel with names}
}
\value{
upDownGene: a vector

logfc: a data.frame
}
\description{
The value means up or down regulated genes for each cluster. 1 suggests that
genes in the cluster is up-regualted genes, while -1 down-regualted genes. 
value within (-1, 1) means genes there are both up and down regulated genes
in the cluster. Return a vector with the length of nCluster if add2 is 
FALSE, or the length of nCluster + 2 if add2 is TRUE and nCluster is not 2. 
In the latter situation, the last two itemes represent Up and Down
reuglated genes
}
\examples{
data(Psoriasis)
annofile <- system.file("extdata", "c2.cp.kegg.v7.01.symbols.gmt.xz", 
package="cogena")


genecl_result <- coExp(DEexprs, nClust=2:3, clMethods=c("hierarchical","kmeans"), 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)

clen_res <- clEnrich(genecl_result, annofile=annofile, sampleLabel=sampleLabel)

upDownGene(clen_res, "kmeans", "3", add2=TRUE)

upDownGene(clen_res, "kmeans", "2", add2=FALSE)

}
