% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSet.R
\name{readSet}
\alias{readSet}
\title{Read set of sequences.}
\usage{
readSet(folder = character(), file = character(), KOs = c(),
  zipped = FALSE, prepend.filenames = FALSE)
}
\arguments{
\item{folder}{Path to directory containing .fasta files.}

\item{file}{Path to a single .fasta file, or zipped file
(if latter, specify \code{ZIPPED = TRUE}).}

\item{KOs}{An optional character vector of sequence annotations (e.g. KO)
contained in the names of fasta files to be selectively read.}

\item{zipped}{Logical, whether \code{folder} or \code{file} is zipped.
Default is \code{FALSE}.}

\item{prepend.filenames}{Logical, whether to prepend filename(s) 
to names in \code{DNAStringSet} object. Default is \code{FALSE}.}
}
\value{
Returns a \code{DNAStringSet} object.
}
\description{
Reads a set of fasta files stored in \code{folder},
or a single fasta \code{file}.
}
\examples{
exampledir <- system.file("extdata", package = "coRdon")
files <- list.files(exampledir)
readSet(folder = exampledir)
readSet(folder = exampledir, KOs = "K02931")
pathtofile <- paste(exampledir, files[1], sep = "/")
readSet(file = pathtofile)

}
