% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonUsage.R
\docType{methods}
\name{codonUsage}
\alias{codonUsage}
\alias{MILC}
\alias{MILC,codonTable-method}
\alias{B}
\alias{B,codonTable-method}
\alias{MCB}
\alias{MCB,codonTable-method}
\alias{ENCprime}
\alias{ENCprime,codonTable-method}
\alias{ENC}
\alias{ENC,codonTable-method}
\alias{SCUO}
\alias{SCUO,codonTable-method}
\title{Calculate CU measures.}
\usage{
MILC(cTobject, subsets = list(), self = TRUE, ribosomal = FALSE,
  id_or_name2 = "1", alt.init = TRUE, stop.rm = FALSE,
  filtering = "none", len.threshold = 80)

\S4method{MILC}{codonTable}(cTobject, subsets = list(), self = TRUE,
  ribosomal = FALSE, id_or_name2 = "1", alt.init = TRUE,
  stop.rm = FALSE, filtering = "none", len.threshold = 80)

B(cTobject, subsets = list(), self = TRUE, ribosomal = FALSE,
  id_or_name2 = "1", alt.init = TRUE, stop.rm = FALSE,
  filtering = "none", len.threshold = 80)

\S4method{B}{codonTable}(cTobject, subsets = list(), self = TRUE,
  ribosomal = FALSE, id_or_name2 = "1", alt.init = TRUE,
  stop.rm = FALSE, filtering = "none", len.threshold = 80)

MCB(cTobject, subsets = list(), self = TRUE, ribosomal = FALSE,
  id_or_name2 = "1", alt.init = TRUE, stop.rm = FALSE,
  filtering = "none", len.threshold = 80)

\S4method{MCB}{codonTable}(cTobject, subsets = list(), self = TRUE,
  ribosomal = FALSE, id_or_name2 = "1", alt.init = TRUE,
  stop.rm = FALSE, filtering = "none", len.threshold = 80)

ENCprime(cTobject, subsets = list(), self = TRUE, ribosomal = FALSE,
  id_or_name2 = "1", alt.init = TRUE, stop.rm = TRUE,
  filtering = "none", len.threshold = 80)

\S4method{ENCprime}{codonTable}(cTobject, subsets = list(),
  self = TRUE, ribosomal = FALSE, id_or_name2 = "1",
  alt.init = TRUE, stop.rm = TRUE, filtering = "none",
  len.threshold = 80)

ENC(cTobject, id_or_name2 = "1", alt.init = TRUE, stop.rm = TRUE,
  filtering = "none", len.threshold = 80)

\S4method{ENC}{codonTable}(cTobject, id_or_name2 = "1",
  alt.init = TRUE, stop.rm = TRUE, filtering = "none",
  len.threshold = 80)

SCUO(cTobject, id_or_name2 = "1", alt.init = TRUE, stop.rm = FALSE,
  filtering = "none", len.threshold = 80)

\S4method{SCUO}{codonTable}(cTobject, id_or_name2 = "1",
  alt.init = TRUE, stop.rm = FALSE, filtering = "none",
  len.threshold = 80)
}
\arguments{
\item{cTobject}{A \code{codonTable} object.}

\item{subsets}{A (named) list of logical vectors, the length of each equal
to \code{getlen(cTobject)}, i.e. the number of sequences in the set, or
character vectors (of any length) containing KEGG/eggNOG annotations,
or codonTable objects (of any length). 
Not used  for \code{ENC}, \code{SCUO} and \code{GCB} calculations.}

\item{self}{Logical, if \code{TRUE} (default), CU statistic is also
calculated against the average CU of the entire set of sequences.
Not used for \code{ENC}, \code{SCUO} and \code{GCB} calculations.}

\item{ribosomal}{Logical, if \code{TRUE}, CU statistic is also calculated
against the average CU of the ribosomal genes in the sequence set.
Not used  for \code{ENC} and \code{SCUO} calculations.
For GCB calculations, if \code{TRUE}, ribosomal genes are used 
as a seed, and if \code{FALSE}  (default), \code{seed} 
has to be specified.}

\item{id_or_name2}{
    A single string that uniquely identifies the genetic code to extract.
    Should be one of the values in the \code{id} or \code{name2} columns
    of \code{GENETIC_CODE_TABLE}.
  }

\item{alt.init}{logical, whether to use alternative initiation codons.
Default is \code{TRUE}.}

\item{stop.rm}{Logical, whether to remove stop codons. Default is
\code{FALSE}.}

\item{filtering}{Character vector, one of \code{c("none", "soft", "hard")}.
Specifies whether sequences shorther than some threshold value of
length (in codons), \code{len.threshold}, should be excluded from
calculations. If \code{"none"} (default), length of sequences is not
checked, if \code{"soft"}, a warrning is printed if there are shorter
sequences, and if \code{"hard"}, these sequences are excluded from
calculation.}

\item{len.threshold}{Optional numeric, specifying sequence length,
in codons, used for filtering.}
}
\value{
A matrix or a numeric vector with CU measure values. 
   For \code{MILC}, \code{B}, \code{ENCprime}, the matrix has a column 
   with values for every specified subset
   (\code{subsets}, \code{self}, \code{ribosomal}).
   A numeric vector for \code{ENC} and \code{SCUO}.
}
\description{
Calculate values of the codon usage (CU) measure 
for every sequence in the given \code{codonTable} object.
The following methods are implemented:
 \code{MILC}, Measure Independent of Length and Composition  
 \href{https://bit.ly/2GkT7qe}{Supek & Vlahovicek (2005)}, 
 \code{B}, codon usage bias (B) 
 \href{https://bit.ly/2DRGdeb}{Karlin et al. (2001)}, 
 \code{ENC}, effective number of codons (ENC) 
 \href{https://www.ncbi.nlm.nih.gov/pubmed/2110097}{Wright (1990)}.
 \code{ENCprime}, effective number of codons prime (ENC') 
 \href{https://www.ncbi.nlm.nih.gov/pubmed/12140252}{Novembre (2002)}, 
 \code{MCB}, maximum-likelihood codon bias (MCB) 
 \href{https://bit.ly/2GlMRyy}{Urrutia and Hurst (2001)}, 
 \code{SCUO}, synonymous codon usage eorderliness (SCUO) 
 \href{https://www.ncbi.nlm.nih.gov/pubmed/15222899}{Wan et al. (2004)}.
}
\examples{
# load example DNA sequences
exampledir <- system.file("extdata", package = "coRdon")
cT <- codonTable(readSet(exampledir))

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
# In the examples below, MILC values are calculated for all sequences; 
# B and ENCprime can be caluclated in the same way.
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

# calculate MILC distance to the average CU of the example DNA sequences
milc <- MILC(cT)
head(milc)

# also calculate MILC distance to the average CU
# of ribosomal genes among the example DNA sequences
milc <- MILC(cT, ribosomal = TRUE)
head(milc)

# calculate MILC distance to the average CU
# of the first 20 example DNA sequences
# (i.e. the first half of the example DNA set)
milc <- MILC(cT, self = FALSE,
             subsets = list(half = c(rep(TRUE, 20), rep(FALSE, 20))))

# alternatively, you can specify codonTable as a subset
halfcT <- codonTable(codonCounts(cT)[1:20,])
milc2 <- MILC(cT, self = FALSE, subsets = list(half = halfcT))
all.equal(milc, milc2) # TRUE

# filtering
MILC(cT, filtering = "hard", len.threshold = 80) # MILC for 9 sequences
sum(getlen(cT) > 80) # 9 sequences are longer than 80 codons
milc1 <- MILC(cT, filtering = "none") # no filtering
milc2 <- MILC(cT, filtering = "soft") # warning
all.equal(milc1, milc2) # TRUE

# options for genetic code
milc <- MILC(cT, stop.rm = TRUE) # don't use stop codons in calculation
milc <- MILC(cT, alt.init = FALSE) # don't use alternative start codons
milc <- MILC(cT, id_or_name2 = "2") # use different genetic code, for help
                                    # see `?Biostrings::GENETIC_CODE`

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
# In the examples below, ENC values are calculated for all sequences; 
# SCUO values can be caluclated in the same way.
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

# calculate ENC
enc <- ENC(cT)
head(enc)

# filtering
ENC(cT, filtering = "hard", len.threshold = 80) # ENC for 9 sequences
sum(getlen(cT) > 80) # 9 sequences are longer than 80 codons
enc1 <- ENC(cT, filtering = "none") # no filtering
enc2 <- ENC(cT, filtering = "soft") # warning
all.equal(enc1, enc2) # TRUE

# options for genetic code
enc <- ENC(cT, stop.rm = TRUE) # don't use stop codons in calculation
enc <- ENC(cT, alt.init = FALSE) # don't use alternative start codons
enc <- ENC(cT, id_or_name2 = "2") # use different genetic code, for help
                                  # see `?Biostrings::GENETIC_CODE`

}
