% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util1_OrderCpGsByLocation.R
\name{OrderCpGsByLocation}
\alias{OrderCpGsByLocation}
\title{Order CpGs by genomic location}
\usage{
OrderCpGsByLocation(
  CpGs_char,
  genome = c("hg19", "hg38"),
  arrayType = c("450k", "EPIC"),
  manifest_gr = NULL,
  ignoreStrand = TRUE,
  output = c("vector", "dataframe")
)
}
\arguments{
\item{CpGs_char}{vector of CpGs}

\item{genome}{Human genome of reference: hg19 or hg38}

\item{arrayType}{Type of array: 450k or EPIC}

\item{manifest_gr}{A GRanges object with the genome manifest (as returned by
\code{\link[ExperimentHub]{ExperimentHub}} or by
\code{\link{ImportSesameData}}). This function by default ignores this
argument in favour of the \code{genome} and \code{arrayType} arguments.}

\item{ignoreStrand}{Whether strand can be ignored, default is TRUE}

\item{output}{vector of CpGs or dataframe with CpGs, CHR, MAPINFO}
}
\value{
vector of CpGs ordered by location or dataframe with CpGs ordered by
  location (cpg), chromosome (chr), position (pos)
}
\description{
Order CpGs by genomic location
}
\examples{

 CpGs_char <- c("cg04677227", "cg07146435", "cg11632906", "cg20214853")
 OrderCpGsByLocation(
   CpGs_char,
   genome = "hg19",
   arrayType = "450k",
   ignoreStrand = TRUE,
   output = "dataframe"
 )

}
