% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotateResults.R
\name{AnnotateResults}
\alias{AnnotateResults}
\title{Annotate \code{coMethDMR} Pipeline Results}
\usage{
AnnotateResults(lmmRes_df, arrayType = c("450k", "EPIC"), nCores_int = 1L, ...)
}
\arguments{
\item{lmmRes_df}{A data frame returned by \code{\link{lmmTestAllRegions}}.
This data frame must contain the following columns:
   \itemize{
     \item{\code{chrom} : }{the chromosome the region is on, e.g. ``chr22''}
     \item{\code{start} : }{the region start point}
     \item{\code{end} : }{the region end point}
   }}

\item{arrayType}{Type of array: 450k or EPIC}

\item{nCores_int}{Number of computing cores to be used when executing code
in parallel. Defaults to 1 (serial computing).}

\item{...}{Dots for additional arguments passed to the cluster constructor.
See \code{\link{CreateParallelWorkers}} for more information.}
}
\value{
A data frame with
   \itemize{
     \item the location of the genomic region's chromosome (\code{chrom}),
       start (\code{start}), and end (\code{end});
   \item UCSC annotation information (\code{UCSC_RefGene_Group},
       \code{UCSC_RefGene_Accession}, and \code{UCSC_RefGene_Name}); and
     \item a list of all of the probes in that region (\code{probes}).
   }
}
\description{
Given a data frame with regions in the genome, add gene symbols,
  UCSC reference gene accession, UCSC reference gene group and
  relation to CpG island.
}
\details{
The region types include \code{"NSHORE"}, \code{"NSHELF"},
   \code{"SSHORE"}, \code{"SSHELF"}, \code{"TSS1500"}, \code{"TSS200"},
   \code{"UTR5"}, \code{"EXON1"}, \code{"GENEBODY"}, \code{"UTR3"}, and
   \code{"ISLAND"}.
}
\examples{
   lmmResults_df <- data.frame(
     chrom = c("chr22", "chr22", "chr22", "chr22", "chr22"),
     start = c("39377790", "50987294", "19746156", "42470063", "43817258"),
     end   = c("39377930", "50987527", "19746368", "42470223", "43817384"),
     regionType = c("TSS1500", "EXON1", "ISLAND", "TSS200", "ISLAND"),
     stringsAsFactors = FALSE
   )

   AnnotateResults(
     lmmRes_df = lmmResults_df,
     arrayType = "450k"
   )

}
