% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/utils.R
\name{subset.gct}
\alias{subset.gct}
\alias{subset_gct}
\alias{subset_gct,GCT-method}
\title{Subset a gct object using the provided row and column ids}
\usage{
\method{subset}{gct}(...)

subset_gct(g, rid = NULL, cid = NULL)

\S4method{subset_gct}{GCT}(g, rid = NULL, cid = NULL)
}
\arguments{
\item{...}{arguments passed on to \code{subset_gct}}

\item{g}{a gct object}

\item{rid}{a vector of character ids or integer indices for ROWS}

\item{cid}{a vector of character ids or integer indices for COLUMNS}
}
\value{
a GCT object
}
\description{
Subset a gct object using the provided row and column ids
}
\examples{
# first 10 rows and columns by index
(a <- subset_gct(ds, rid=1:10, cid=1:10))

# first 10 rows and columns using character ids
# use \code{ids} to extract the ids
rid <- ids(ds)
cid <- ids(ds, dimension="col")
(b <- subset_gct(ds, rid=rid[1:10], cid=cid[1:10]))

identical(a, b) # TRUE

}
\seealso{
Other GCT utilities: 
\code{\link{annotate.gct}()},
\code{\link{melt.gct}()},
\code{\link{merge.gct}()},
\code{\link{rank.gct}()}
}
\concept{GCT utilities}
