% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/utils.R
\name{merge.gct}
\alias{merge.gct}
\alias{merge_gct}
\alias{merge_gct,GCT,GCT-method}
\title{Merge two GCT objects together}
\usage{
\method{merge}{gct}(...)

merge_gct(g1, g2, dim = "row", matrix_only = FALSE)

\S4method{merge_gct}{GCT,GCT}(g1, g2, dim = "row", matrix_only = FALSE)
}
\arguments{
\item{...}{arguments passed on to \code{merge_gct}}

\item{g1}{the first GCT object}

\item{g2}{the second GCT object}

\item{dim}{the dimension on which to merge (row or column)}

\item{matrix_only}{boolean idicating whether to keep only the
data matrices from \code{g1} and \code{g2} and ignore their
row and column meta data}
}
\value{
a GCT object
}
\description{
Merge two GCT objects together
}
\examples{
# take the first 10 and last 10 rows of an object
# and merge them back together
(a <- subset_gct(ds, rid=1:10))
(b <- subset_gct(ds, rid=969:978))
(merged <- merge_gct(a, b, dim="row"))

}
\seealso{
Other GCT utilities: 
\code{\link{annotate.gct}()},
\code{\link{melt.gct}()},
\code{\link{rank.gct}()},
\code{\link{subset.gct}()}
}
\concept{GCT utilities}
