% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/utils.R
\name{melt.gct}
\alias{melt.gct}
\alias{melt_gct}
\alias{melt_gct,GCT-method}
\title{Transform a GCT object in to a long form \code{\link{data.table}}
(aka 'melt')}
\usage{
melt.gct(...)

melt_gct(
  g,
  suffixes = NULL,
  remove_symmetries = FALSE,
  keep_rdesc = TRUE,
  keep_cdesc = TRUE,
  ...
)

\S4method{melt_gct}{GCT}(
  g,
  suffixes = NULL,
  remove_symmetries = FALSE,
  keep_rdesc = TRUE,
  keep_cdesc = TRUE,
  ...
)
}
\arguments{
\item{...}{further arguments passed along to \code{data.table::merge}}

\item{g}{the GCT object}

\item{suffixes}{the character suffixes to be applied if there are
collisions between the names of the row and column descriptors}

\item{remove_symmetries}{boolean indicating whether to remove
the lower triangle of the matrix (only applies if \code{g@mat}
is symmetric)}

\item{keep_rdesc}{boolean indicating whether to keep the row
descriptors in the final result}

\item{keep_cdesc}{boolean indicating whether to keep the column
descriptors in the final result}
}
\value{
a \code{\link{data.table}} object with the row and column ids and
  the matrix
  values and (optinally) the row and column descriptors
}
\description{
Utilizes the \code{\link{melt.data.table}} function to
  transform the
  matrix into long form. Optionally can include the row and column
  annotations in the transformed \code{\link{data.table}}.
}
\examples{
# simple melt, keeping both row and column meta
head(melt_gct(ds))

# update row/colum suffixes to indicate rows are genes, columns experiments
head(melt_gct(ds, suffixes = c("_gene", "_experiment")))

# ignore row/column meta
head(melt_gct(ds, keep_rdesc = FALSE, keep_cdesc = FALSE))

}
\seealso{
Other GCT utilities: 
\code{\link{annotate.gct}()},
\code{\link{merge.gct}()},
\code{\link{rank.gct}()},
\code{\link{subset.gct}()}
}
\concept{GCT utilities}
