% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/io.R
\name{fix.datatypes}
\alias{fix.datatypes}
\alias{fix_datatypes}
\title{Adjust the data types for columns of a meta data frame}
\usage{
fix.datatypes(...)

fix_datatypes(meta)
}
\arguments{
\item{...}{arguments passed on to \code{fix_datatypes}}

\item{meta}{a data.frame}
}
\value{
meta the same data frame with (potentially) adjusted
  column types.
}
\description{
GCT(X) parsing initially returns data frames
  of row and column descriptors where all columns are of
  type character. This is inconvenient for analysis, so
  the goal of this function is to try and guess the
  appropriate data type for each column.
}
\details{
This is a low-level helper function
  which most users will not need to access directly
}
\examples{
# meta data table with all character types
str(cdesc_char)
fixed <- cmapR:::fix_datatypes(cdesc_char)
# note how some column classes have changed
str(fixed)

}
\seealso{
Other GCTX parsing functions: 
\code{\link{GCT}},
\code{\link{append.dim}()},
\code{\link{parse.gctx}()},
\code{\link{process_ids}()},
\code{\link{read.gctx.ids}()},
\code{\link{read.gctx.meta}()},
\code{\link{write.gctx.meta}()},
\code{\link{write.gctx}()},
\code{\link{write.gct}()}
}
\concept{GCTX parsing functions}
\keyword{internal}
