% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{distil}
\alias{distil}
\title{Collapse the rows or columns of a matrix using  
weighted averaging}
\usage{
distil(m, dimension = "col", method = "spearman")
}
\arguments{
\item{m}{a numeric matrix where the rows or columns are
assumed to be replicates}

\item{dimension}{the dimension to collapse. either 'row'
or 'col'}

\item{method}{the correlation method to use}
}
\value{
a list with the following elements
 \describe{
   \item{values}{a vector of the collapsed values}
   \item{correlations}{a vector of the pairwise correlations}
   \item{weights}{a vector of the computed weights}
 }
}
\description{
This is equivalent to the 'modz' procedure
  used in collapsing replicates in traditional L1000
  data processing. The weight for each replicate is
  computed as its normalized average correlation to
  the other replicates in the set.
}
\examples{
m <- matrix(rnorm(30), ncol=3)
distil(m)

}
