% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_colnames}
\alias{check_colnames}
\title{Check whether \code{test_names} are columns in the \code{\link{data.frame}}
df}
\usage{
check_colnames(test_names, df, throw_error = TRUE)
}
\arguments{
\item{test_names}{a vector of column names to test}

\item{df}{the \code{\link{data.frame}} to test against}

\item{throw_error}{boolean indicating whether to throw an error if
any \code{test_names} are not found in \code{df}}
}
\value{
boolean indicating whether or not all \code{test_names} are
  columns of \code{df}
}
\description{
Check whether \code{test_names} are columns in the \code{\link{data.frame}}
df
}
\examples{
check_colnames(c("pert_id", "pert_iname"), cdesc_char) # TRUE
check_colnames(c("pert_id", "foobar"),
  cdesc_char, throw_error=FALSE)# FALSE, suppress error
}
