% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{align_matrices}
\alias{align_matrices}
\title{Align the rows and columns of two (or more) matrices}
\usage{
align_matrices(m1, m2, ..., L = NULL, na.pad = TRUE, as.3D = TRUE)
}
\arguments{
\item{m1}{a matrix with unique row and column names}

\item{m2}{a matrix with unique row and column names}

\item{...}{additional matrices with unique row and
column names}

\item{L}{a list of matrix objects. If this is given,
m1, m2, and ... are ignored}

\item{na.pad}{boolean indicating whether to pad the
combined matrix with NAs for rows/columns that are
not shared by m1 and m2.}

\item{as.3D}{boolean indicating whether to return the
result as a 3D array. If FALSE, will return a list.}
}
\value{
an object containing the aligned matrices. Will
  either be a list or a 3D array
}
\description{
Align the rows and columns of two (or more) matrices
}
\examples{
# construct some example matrices
m1 <- matrix(rnorm(20), nrow=4)
rownames(m1) <- letters[1:4]
colnames(m1) <- LETTERS[1:5]
m2 <- matrix(rnorm(20), nrow=5)
rownames(m2) <- letters[1:5]
colnames(m2) <- LETTERS[1:4]
m1
m2

# align them, padding with NA and returning a 3D array
align_matrices(m1, m2)

# align them, not padding and retuning a list
align_matrices(m1, m2, na.pad=FALSE, as.3D=FALSE)

}
