% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{marker_select}
\alias{marker_select}
\title{decide for one gene whether it is a marker for a certain cell type}
\usage{
marker_select(row1, cols, cut = 1, compto = 1)
}
\arguments{
\item{row1}{a numeric vector of expression values (row)}

\item{cols}{a vector of cell types (column)}

\item{cut}{an expression minimum cutoff}

\item{compto}{compare max expression to the value of next 1 or more}
}
\value{
vector of cluster name and ratio value
}
\description{
decide for one gene whether it is a marker for a certain cell type
}
\examples{
pbmc_avg <- average_clusters(
    mat = pbmc_matrix_small,
    metadata = pbmc_meta,
    cluster_col = "classified",
    if_log = FALSE
)

marker_select(
    row1 = pbmc_avg["PPBP", ],
    cols = names(pbmc_avg["PPBP", ])
)
}
