% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{clustify_lists}
\alias{clustify_lists}
\alias{clustify_lists.default}
\alias{clustify_lists.Seurat}
\alias{clustify_lists.SingleCellExperiment}
\title{Main function to compare scRNA-seq data to gene lists.}
\usage{
clustify_lists(input, ...)

\method{clustify_lists}{default}(
  input,
  marker,
  marker_inmatrix = TRUE,
  metadata = NULL,
  cluster_col = NULL,
  if_log = TRUE,
  per_cell = FALSE,
  topn = 800,
  cut = 0,
  genome_n = 30000,
  metric = "hyper",
  output_high = TRUE,
  lookuptable = NULL,
  obj_out = TRUE,
  seurat_out = obj_out,
  vec_out = FALSE,
  rename_prefix = NULL,
  threshold = 0,
  low_threshold_cell = 0,
  verbose = TRUE,
  input_markers = FALSE,
  details_out = FALSE,
  ...
)

\method{clustify_lists}{Seurat}(
  input,
  metadata = NULL,
  cluster_col = NULL,
  if_log = TRUE,
  per_cell = FALSE,
  topn = 800,
  cut = 0,
  marker,
  marker_inmatrix = TRUE,
  genome_n = 30000,
  metric = "hyper",
  output_high = TRUE,
  dr = "umap",
  obj_out = TRUE,
  seurat_out = obj_out,
  vec_out = FALSE,
  threshold = 0,
  rename_prefix = NULL,
  verbose = TRUE,
  details_out = FALSE,
  ...
)

\method{clustify_lists}{SingleCellExperiment}(
  input,
  metadata = NULL,
  cluster_col = NULL,
  if_log = TRUE,
  per_cell = FALSE,
  topn = 800,
  cut = 0,
  marker,
  marker_inmatrix = TRUE,
  genome_n = 30000,
  metric = "hyper",
  output_high = TRUE,
  dr = "umap",
  obj_out = TRUE,
  seurat_out = obj_out,
  vec_out = FALSE,
  threshold = 0,
  rename_prefix = NULL,
  verbose = TRUE,
  details_out = FALSE,
  ...
)
}
\arguments{
\item{input}{single-cell expression matrix, Seurat object, or SingleCellExperiment}

\item{...}{passed to matrixize_markers}

\item{marker}{matrix or dataframe of candidate genes for each cluster}

\item{marker_inmatrix}{whether markers genes are already in preprocessed
matrix form}

\item{metadata}{cell cluster assignments,
supplied as a vector or data.frame.
If data.frame is supplied then \code{cluster_col} needs to be set.
Not required if running correlation per cell.}

\item{cluster_col}{column in metadata with cluster number}

\item{if_log}{input data is natural log, averaging will be done on
unlogged data}

\item{per_cell}{compare per cell or per cluster}

\item{topn}{number of top expressing genes to keep from input matrix}

\item{cut}{expression cut off from input matrix}

\item{genome_n}{number of genes in the genome}

\item{metric}{adjusted p-value for hypergeometric test, or jaccard index}

\item{output_high}{if true (by default to fit with rest of package),
-log10 transform p-value}

\item{lookuptable}{if not supplied, will look in built-in table
for object parsing}

\item{obj_out}{whether to output object instead of cor matrix}

\item{seurat_out}{output cor matrix or called seurat object
(deprecated, use obj_out instead)}

\item{vec_out}{only output a result vector in the same order as metadata}

\item{rename_prefix}{prefix to add to type and r column names}

\item{threshold}{identity calling minimum correlation score threshold,
only used when obj_out = T}

\item{low_threshold_cell}{option to remove clusters with too few cells}

\item{verbose}{whether to report certain variables chosen and steps}

\item{input_markers}{whether input is marker data.frame of 0 and 1s (output of pos_neg_marker), and uses alternate enrichment mode}

\item{details_out}{whether to also output shared gene list from jaccard}

\item{dr}{stored dimension reduction}
}
\value{
matrix of numeric values, clusters from input as row names,
cell types from marker_mat as column names
}
\description{
Main function to compare scRNA-seq data to gene lists.
}
\examples{
# Annotate a matrix and metadata

# Annotate using a different method
clustify_lists(
    input = pbmc_matrix_small,
    marker = cbmc_m,
    metadata = pbmc_meta,
    cluster_col = "classified",
    verbose = TRUE,
    metric = "jaccard"
)
}
