% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataCreation.R
\docType{data}
\name{rsecFluidigm}
\alias{rsecFluidigm}
\alias{makeRsecFluidigmObject}
\title{Documentation of rsecFluidigm object}
\format{
\code{rsecFluidigm} is a \code{ClusterExperiment} object, the result
  of running \code{\link{RSEC}} on fluidigm data described in vignette and
  available in the \code{scRNAseq} package.
}
\usage{
makeRsecFluidigmObject(object)
}
\arguments{
\item{object}{object given to functions}
}
\description{
Documentation of the creation of rsecFluidigm, result of RSEC
  run on fluidigm data for vignette
}
\details{
The functions \code{makeRsecFluidigmObject} and 
  \code{checkRsecFluidigmObject} are helper functions whose sole purpose is 
  to create \code{rsecFluidigm} and check that the results are the same as 
  expected. \code{makeRsecFluidigmObject} also serves as documentation of the
  specific RSEC call that was made to create the \code{rsecFluidigm} object, 
  as well as filtering and normalization of the fluidigm data.
  The purpose of making them functions is internal, to help more easily
  mantain and check if changes to the package have affected the results.
}
\examples{
# see code used create rsecFluidigm 
# (print out the function)
makeRsecFluidigmObject
#code actualy run to create rsecFluidigm:
\dontrun{
library(clusterExperiment)
data(fluidigmData)
data(fluidigmColData)
se<-SummarizedExperiment(assays=fluidigmData, colData=fluidigmColData)
RNGversion("3.5.0")
rsecFluidigm<-makeRsecFluidigmObject(se)
# Internal function for checking got correct results...
clusterExperiment:::checkRsecFluidigmObject(rsecFluidigm)
usethis::use_data(rsecFluidigm,overwrite=FALSE)
}
}
\seealso{
\code{\link[scRNAseq]{fluidigm}}.
}
\author{
Elizabeth Purdom \email{epurdom@stat.berkeley.edu}
}
\keyword{data}
