% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotContrastHeatmap.R
\name{plotContrastHeatmap,ClusterExperiment-method}
\alias{plotContrastHeatmap,ClusterExperiment-method}
\alias{plotContrastHeatmap}
\title{Plot heatmaps showing significant genes per contrast}
\usage{
\S4method{plotContrastHeatmap}{ClusterExperiment}(
  object,
  signifTable,
  whichCluster = NULL,
  contrastColors = NULL,
  ...
)
}
\arguments{
\item{object}{ClusterExperiment object on which biomarkers were found}

\item{signifTable}{A \code{data.frame} in format of the result of
\code{\link{getBestFeatures}}. It must minimally contain columns 'Contrast'
and 'IndexInOriginal' giving the grouping and original index of the
features in the \code{assay(object)}}

\item{whichCluster}{if not NULL, indicates cluster used in making the 
significance table. Used to match to colors in \code{clusterLegend(object)} 
(relevant for one-vs-all contrast so that color aligns). See description of 
argument in \code{\link{getClusterIndex}} for futher details.}

\item{contrastColors}{vector of colors to be given to contrasts. Should match
the name of the contrasts in the 'Contrast' column of \code{signifTable} or
'ContrastName', if given.. If  missing, default colors given by match to
the cluster names of \code{whichCluster} (see above), or otherwise given a
default assignment.}

\item{...}{Arguments passed to \code{\link{plotHeatmap}}}
}
\value{
A heatmap is created. The output of \code{plotHeatmap} is returned.
}
\description{
Plots a heatmap of the data, with the genes grouped based on the
  contrast for which they were significant.
}
\details{
If the column 'ContrastName' is given in \code{signifTable}, these
  names will be used to describe the contrast in the legend.

Within each contrast, the genes are sorted by log fold-change if the
  column "logFC" is in the \code{signifTable} data.frame

Note that if \code{whichCluster} is NOT given (the default) then there is 
no automatic match of colors with contrasts based on the information in 
\code{object}.
}
\examples{
data(simData)

cl <- clusterSingle(simData, subsample=FALSE,
sequential=FALSE, 
mainClusterArgs=list(clusterFunction="pam", clusterArgs=list(k=8)))

#Do all pairwise, only return significant, try different adjustments:
pairsPerC <- getBestFeatures(cl, contrastType="Pairs", number=5,
p.value=0.05, DEMethod="limma")
plotContrastHeatmap(cl,pairsPerC)
}
\seealso{
\code{\link{plotHeatmap}}, \code{\link{makeBlankData}},
  \code{\link{getBestFeatures}}
}
