% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotClustersWorkflow.R
\name{plotClustersWorkflow,ClusterExperiment-method}
\alias{plotClustersWorkflow,ClusterExperiment-method}
\alias{plotClustersWorkflow}
\title{A plot of clusterings specific for clusterMany and workflow
  visualization}
\usage{
\S4method{plotClustersWorkflow}{ClusterExperiment}(
  object,
  whichClusters = c("mergeClusters", "makeConsensus"),
  whichClusterMany = NULL,
  nBlankLines = ceiling(nClusterings(object) * 0.05),
  existingColors = c("ignore", "all", "highlightOnly"),
  nSizeResult = ceiling(nClusterings(object) * 0.02),
  clusterLabels = TRUE,
  clusterManyLabels = TRUE,
  sortBy = c("highlighted", "clusterMany"),
  highlightOnTop = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{ClusterExperiment} object on which
\code{\link{clusterMany}} has been run}

\item{whichClusters}{which clusterings to "highlight", i.e draw separately
from the bulk of the plot, see argument \code{whichClusters} of
\code{\link{getClusterIndex}} for description of format allowed.}

\item{whichClusterMany}{indicate which clusterings to plot in the bulk of the
plot, see argument \code{whichClusters} of \code{\link{getClusterIndex}}
for description of format allowed.}

\item{nBlankLines}{the number of blank (i.e. white) rows to add between the
clusterMany clusterings and the highlighted clusterings.}

\item{existingColors}{one of "ignore","all","highlightOnly". Whether the plot
should use the stored colors in the \code{ClusterExperiment} object given.
"highlightOnly" means only the highlighted clusters will use the stored
colors, not the clusterMany clusterings.}

\item{nSizeResult}{the number of rows each highlighted clustering should take up.
Increasing the number increases the thickness of the rectangles
representing the highlighted clusterings.}

\item{clusterLabels}{either logical, indicating whether to plot the labels
for the clusterings identified to be highlighted in the
\code{whichClusters} argument, or a character vector of labels to use.}

\item{clusterManyLabels}{either logical, indicating whether to plot the
labels for the clusterings from clusterMany identified in the
\code{whichClusterMany}, or a character vector of labels to use.}

\item{sortBy}{how to align the clusters. If "highlighted" then the
highlighted clusters indicated in the argument \code{whichClusters} are
first in the alignment done by \code{plotClusters}. If "clusterMany", then
the clusterMany results are first in the alignment. (Note this does not
determine where they will be plotted, but how they are ordered in the
aligning step done by \code{plotClusters})}

\item{highlightOnTop}{logical. Whether the highlighted clusters should be
plotted on the top of clusterMany results or underneath.}

\item{...}{arguments passed to the matrix version of
\code{\link{plotClusters}}}
}
\value{
A plot is produced, nothing is returned.
}
\description{
A realization of \code{\link{plotClusters}} call specific to
  separating out the results of \code{clusterMany} and other clustering
  results.
}
\details{
This plot is solely intended to make it easier to use the 
    \code{\link{plotClusters}} visualization when there are a large number of
    clusterings from a call to \code{\link{clusterMany}}. This plot separates
    out the \code{\link{clusterMany}} results from a designated clustering of
    interest, as indicated by the \code{whichClusters} argument
    (by default clusterings from a call to \code{\link{makeConsensus}} or 
    \code{\link{mergeClusters}}). In addition the highlighted clusters are
    made bigger so that they can be easily seen.
}
\examples{
#clustering using pam: try using different dimensions of pca and different k
\dontrun{
data(simData)

cl <- clusterMany(simData, nReducedDims=c(5, 10, 50), reduceMethod="PCA",
clusterFunction="pam", ks=2:4, findBestK=c(TRUE,FALSE),
removeSil=c(TRUE,FALSE), makeMissingDiss=TRUE)
cl <- makeConsensus(cl, proportion=0.7)
plotClustersWorkflow(cl)
}
}
\seealso{
\code{\link{plotClusters}}, \code{\link{clusterMany}}
}
