% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParams.R
\name{getClusterManyParams,ClusterExperiment-method}
\alias{getClusterManyParams,ClusterExperiment-method}
\alias{getClusterManyParams}
\title{Get parameter values of clusterMany clusters}
\usage{
\S4method{getClusterManyParams}{ClusterExperiment}(
  x,
  whichClusters = "clusterMany",
  searchAll = FALSE,
  simplify = TRUE
)
}
\arguments{
\item{x}{a ClusterExperiment object that contains clusterings from running
\code{\link{clusterMany}}.}

\item{whichClusters}{argument that can be either numeric or character vector
indicating the clusterings to be used. See details of \code{\link{getClusterIndex}}.}

\item{searchAll}{logical, indicating whether all clusterings with 
\code{clusterMany} label should be allowed (i.e. including those from
 previous ones with labels like \code{clusterMany.1}), or only limited 
 to those in most recent workflow (default).}

\item{simplify}{logical. Whether to simplify the output so as to remove 
features that do not change across the clusterings.}
}
\value{
Returns a data.frame where the column names are the parameter names,
  and the entries are the values of the parameter for the indicated
  clustering. The column 'clusteringIndex' identifies the index of the
  clustering in the full set of clusterings of the given ClusterExperiment
  object.
}
\description{
Takes an input a ClusterExperiment object and returns the
  parameter values used in creating the clusters that were created by
  'clusterMany'
}
\details{
The method simply parses the \code{clusterLabels} of the indicated
  clusterings, relying on the specific format used by \code{clusterMany} to
  create labels. The function will only allow the parsing to be performed on
  those clusterings with a 'clusterMany' clusterType. If the user has
  manipulated the clusterLabels manually or manually identified the
  clusterType of a clustering as 'clusterMany', this function may create
  unexpected results or errors. Similarly, it cannot be used on 'clusterMany'
  results from an old iteration (e.g. that have type 'clusterMany.1')

Specifically, it splits the label of each clustering by the
  character ",", as indicating the different parameters; this should return a
  value of form "ABC=123". The function then pulls out the numeric value
  ('123') and associates that value as the value of the parameter ('ABC')
}
\examples{
\dontrun{
data(simData)

cl <- clusterMany(simData, nReducedDims=c(5, 10), reduceMethod="PCA",
     clusterFunction="pam", ks=2:4, findBestK=c(TRUE,FALSE), 
     makeMissingDiss=TRUE, removeSil=c(TRUE,FALSE))
getClusterManyParams(cl)
}
}
