% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initClustering.R
\name{p1_clustering}
\alias{p1_clustering}
\title{Initial non-spatial clustering}
\usage{
p1_clustering(
  spe,
  dimRed = "None",
  batch = FALSE,
  batch_by = "None",
  threads = 1,
  clustParams = list(clust_c = 0, subclust_c = 0, iter.max = 30, k = 10, cluster.fun =
    "louvain")
)
}
\arguments{
\item{spe}{a SpatialExperiment object containing spatial coordinates in
'spatialCoords' matrix and normalised gene expression in 'logcounts' assay.}

\item{dimRed}{a character indicating the name of the reduced dimensions to
use from the SpatialExperiment object (i.e., from reducedDimNames(spe)).
Default value is 'None'.}

\item{batch}{a logical parameter for whether to perform batch correction.
Default value is FALSE.}

\item{batch_by}{a character indicating name of colData(spe) column containing
the batch names. Default value is 'None'.}

\item{threads}{a numeric value for the number of CPU cores to be used for the
analysis. Default value set to 1.}

\item{clustParams}{a list of parameters for TwoStepParam clustering methods:
clust_c is the number of centers to use for clustering with KmeansParam. By
default set to 0, in which case the method uses either 5000 centers or 1/5th
of the total cells in the data as the number of centers, whichever is lower.
subclust_c is the number of centers to use for sub-clustering the initial
clusters with KmeansParam. The default value is 0, in which case the method
uses either 1 center or half of the total cells in the initial cluster as
the number of centers, whichever is higher.
iter.max is the maximum number of iterations to perform during clustering
and sub-clustering with KmeansParam. Default value is 30.
k is a numeric value indicating the k-value used for clustering and
sub-clustering with NNGraphParam. Default value is 10.
cluster.fun is a character indicating the graph clustering method used with
NNGraphParam. By default, the Louvain method is used.}
}
\value{
SpatialExperiment object with initial cluster and subcluster labels
of each cell.
}
\description{
A function to perform initial non-spatial clustering and sub-clustering of
normalised gene expression to generate 'initial clusters' and 'initial
subclusters'.
}
\examples{
data(ClustSignal_example)

spe <- clustSIGNAL::p1_clustering(spe, dimRed = "PCA")
spe$nsCluster |> head()
spe$initCluster |> head()
}
