% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/buildNetwork.R
\name{createNetwork}
\alias{createNetwork}
\alias{createNetwork,xcmsSet-method}
\alias{createNetwork,XCMSnExp-method}
\title{Generic function to create a similarity network
from processed m/z data}
\usage{
createNetwork(
  mzdata,
  peaklist,
  filter = TRUE,
  mzerror = 5e-06,
  intdiff = 1e-04,
  rtdiff = 1e-04
)

\S4method{createNetwork}{xcmsSet}(
  mzdata,
  peaklist,
  filter = TRUE,
  mzerror = 5e-06,
  intdiff = 1e-04,
  rtdiff = 1e-04
)

\S4method{createNetwork}{XCMSnExp}(
  mzdata,
  peaklist,
  filter = TRUE,
  mzerror = 5e-06,
  intdiff = 1e-04,
  rtdiff = 1e-04
)
}
\arguments{
\item{mzdata}{An object of class 'xcmsSet' or 'XCMSnExp'
with processed m/z data.}

\item{peaklist}{Is a data.frame feature info for m/z data.
put each feature in a row and a column 'mz' for mass data, 
retention time column 'rt' and intensity in column 'maxo'.}

\item{filter}{If TRUE, filter out very similar features
that have a correlation similarity > 0.99 and equal values of m/z,
retention time and intensity.}

\item{mzerror}{Relative error for m/z, if relative error 
between two features is below that value that features
are considered with similar m/z value.}

\item{intdiff}{Relative error for intensity, if relative
error between two features is below that value that
features are considered with similar intensity}

\item{rtdiff}{Relative error for retention time, if 
relative error between two features is below that value
that features are considered with similar retention time}
}
\value{
This function returns a list with the similarity
network and the filtered peaklist if 'filter' = TRUE. If
filter = FALSE the peaklist is returned unmodified.
}
\description{
This function creates a similarity network with nodes as features
and weighted edges as the cosine similarity between those nodes.
Edges with weights = 0 are not included in the network. Nodes
without edges are not included in the network. This network will
be used to define clique groups and find annotation within this
groups.
}
\details{
Signal processing algorithms may output artefact features.
Sometimes they produce two artefact features which are almost identical
This artefacts may lead to errors in the computation of the clique
groups, so it is recommended to set 'filter' = TRUE to drop repeated
features.
}
\section{Functions}{
\itemize{
\item \code{createNetwork(xcmsSet)}: To use with 'xcmsSet' class

\item \code{createNetwork(XCMSnExp)}: To use with 'XCMSnExp' class

}}
\examples{
## Using a 'xcmsSet' object
mzfile <- system.file("standards.mzXML", package = "cliqueMS")
require(xcms)
rawMS <- MSnbase::readMSData(files = mzfile, mode = "onDisk")
cpw <- CentWaveParam(ppm = 15, peakwidth = c(5,20), snthresh = 10)
mzData <- findChromPeaks(rawMS, cpw)
peaklist = as.data.frame(chromPeaks(mzData))
netlist = createNetwork(mzData, peaklist, filter = TRUE)

## Using a 'XCMSnExp' object
require(xcms)
mzfile <- system.file("standards.mzXML", package = "cliqueMS")
rawMS <- MSnbase::readMSData(files = mzfile, mode = "onDisk")
cpw <- CentWaveParam(ppm = 15, peakwidth = c(5,20), snthresh = 10)
mzData <- findChromPeaks(rawMS, cpw)
peaklist = as.data.frame(chromPeaks(mzData))
netlist = createNetwork(mzData, peaklist, filter = TRUE)
}
\seealso{
\code{\link{getCliques}}
}
