% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\name{anClique}
\alias{anClique}
\title{'anClique' class constructor}
\usage{
anClique(
  peaklist = data.frame(),
  network = igraph::make_empty_graph(directed = FALSE),
  cliques = list(),
  cliquesFound = FALSE,
  isotopes = data.frame(),
  isoFound = FALSE,
  anFound = FALSE
)
}
\arguments{
\item{peaklist}{'data.frame' with feature and annotation information.}

\item{network}{'igraph' undirected network of similarity.}

\item{cliques}{list with the groups of features}

\item{cliquesFound}{'TRUE' if cliques have been computed.}

\item{isotopes}{'data.frame' with isotope annotation.}

\item{isoFound}{'TRUE' if isotopes have been computed.}

\item{anFound}{'TRUE' if annotation has been computed.}
}
\value{
A new 'anClique' object with variable values set by the user.
}
\description{
S4 Class \code{anClique} for annotating isotopes and adducts
in processed m/z data. Features are first
grouped based on a similarity network algorithm and then
annotation of isotopes and adducts is performed in each group.
}
\details{
See \code{help("anClique-class")} for information about the
slots and methods of the S4 class 'anClique'.
}
\examples{
mzfile <- system.file("standards.mzXML", package = "cliqueMS")
library(xcms)
mzraw <- MSnbase::readMSData(files = mzfile, mode = "onDisk")
cpw <- CentWaveParam(ppm = 15, peakwidth = c(5,20), snthresh = 10)
mzData <- findChromPeaks(object = mzraw, param = cpw)
ex.anClique <- createanClique(mzdata = mzData)
show(ex.anClique)
}
\seealso{
\code{\link{createanClique}}

\code{\link{anClique-class}}
}
