% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-intronProfile.R
\name{intronProfile}
\alias{intronProfile}
\title{intronProfile for the GRanges objects}
\usage{
intronProfile(
    object,
    annotation,
    title = "Intron Profile",
    group = NA,
    exlevel = NA,
    extranscript_support_level = NA,
    maxLength = NA,
    minLength = NA,
    nomap = FALSE
)
}
\arguments{
\item{object}{A GRanges object which should contains all the peaks that you
want to check}

\item{annotation}{A path way to the annotation file. The format of the
annotation file should be gff3 and downloaded from
https://www.gencodegenes.org/}

\item{title}{The main title for the output meta gene profile plot.}

\item{group}{The column name which contains the information of grouping
for making the comparison plot. NA means all the peaks belongs to
the same catagory.}

\item{exlevel}{A parameter for the annotation filtering. exlevel represents
the level that you would like to exclude. NA means no level filtering
for the annotation file. The level from the annotations refers to
how reliable this annotation is. For more information about level
please check
https://www.gencodegenes.org/pages/data_format.html.}

\item{extranscript_support_level}{A parameter for the annotation filtering.
extranscript_support_level represents the transcript_support_level
that you would like to exclude (e.g. 4 and 5). NA means no
transcript_support_level filtering for the annotation file.
Transcripts are scored according to how well mRNA and EST alignments
match over its full length. Here the number 6 means the
transcript_support_level NA. For more information about level please
check
https://www.gencodegenes.org/pages/data_format.html.}

\item{maxLength}{A numeric value which indicate the maximum value of exon
length for the annotation filtering. Or a NA which will
turn off the max length annotation filtering.}

\item{minLength}{A numeric value which indicate the minimum value of exon
length for the annotation filtering. Or a NA which will
turn off the min length annotation filtering.}

\item{nomap}{A logical vector (TRUE or FALSE). It indicates whether you
would like to exclude peaks that cannot assign to annotations
in the plot.}
}
\value{
A list object, the list 1 contains the information of the
    assignment of the peaks and their position value within the intron.
    The value close to 1 means the peak close to the 3' splice site.
    The list 2 includes the plot of intronProfile.
}
\description{
An function to check the position of peaks in the intronic
    region.
}
\details{
\itemize{
    Here is an explanation of output meta data in the \code{list 1}:
    \item \code{center}: The center position of each peaks. This center
    position is used for calculating the position of peaks within the
    genomic regions.
    \item \code{Intron_S} and \code{Intron_E}: The location of 5' and 3'
    splice sites (SS) of the intron.
    \item \code{Intron_length}: The length of the intron that peak assigned.
    \item \code{Intron_transcript_id}: The transcript ID for the intron.
    \item \code{Intron_map}: The relative position of each peak. This value
    close to 0 means this peak located close to the 5' SS. The position
    value close to one means the peak close to the 3' SS. Value 3 means
    this peaks can not map to any annotation.
}
}
\examples{
## Load the test data and get the path to the test gff3 file
testpath <- system.file("extdata", package = "cliProfiler")
test <- readRDS(file.path(testpath, "test.rds"))
test_gff3 <- file.path(testpath, "annotation_test.gff3")

output <- intronProfile(test, test_gff3)
}
\author{
You Zhou, Kathi Zarnack
}
