% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liftBSJcoords.R
\name{liftBSJcoords}
\alias{liftBSJcoords}
\title{LiftOver back-spliced junction coordinates}
\usage{
liftBSJcoords(
  backSplicedJunctions,
  map = "hg19ToMm9",
  annotationHubID = "AH14155"
)
}
\arguments{
\item{backSplicedJunctions}{A data frame containing the back-spliced junction
coordinates (predicted or randomly selected).
See \code{\link{getRandomBSJunctions}}, \code{\link{getBackSplicedJunctions}}
and \code{\link{mergeBSJunctions}} (to group circRNAs detected by multiple
detection tools), on how to generated this data frame.}

\item{map}{A character string in the format <db1>To<Db2> (e.g."hg19ToMm9")
specifying the reference genome mapping logic associated with a
valid .chain file. Default value is "hg19ToMm9".}

\item{annotationHubID}{A string specifying the AnnotationHub id associated
with a valid *.chain file. Type data(ahChainFiles) to see all possibile
options. E.g. if AH14155 is specified, the hg19ToMm9.over.chain.gz will
be used to convert the hg19 (Human GRCh37) coordinates to mm10
(Mouse GRCm38). Default value is "AH14155".}
}
\value{
a data frame.
}
\description{
The function liftBSJcoords() maps back-spliced junction
coordinates between species ad genome assemblies by using the liftOver utility
from UCSC. Only back-spliced junction coordinates where the mapping was
successful are reported.
}
\examples{
# Load a data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# LiftOver the first 10 back-spliced junction coordinates
liftedBSJcoords <- liftBSJcoords(mergedBSJunctions[1:10,], map = "hg19ToMm9")

}
