% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCircSeqs.R
\name{getCircSeqs}
\alias{getCircSeqs}
\title{Retrieve circRNA sequences}
\usage{
getCircSeqs(annotatedBSJs, gtf, genome)
}
\arguments{
\item{annotatedBSJs}{A data frame with the annotated back-spliced junctions.
It can be generated with \code{\link{annotateBSJs}}.}

\item{gtf}{A data frame containing genome annotation information. It can be
generated with \code{\link{formatGTF}}.}

\item{genome}{A BSgenome object containing the genome sequences.
It can be generated with \code{\link{getBSgenome}}.
See \code{\link[BSgenome]{available.genomes}} to see the BSgenome package
currently available}
}
\value{
A list.
}
\description{
The function getCircSeqs() retrieves the circRNA
sequences. The circRNA sequence is given by the sequences of the exons
in between the back-spliced-junctions.The exon sequences are retrieved and
then concatenated together to recreate the circRNA sequence. To recreate
the back-spliced junction sequence 50 nucleotides are taken from the 5'
head and attached at the 3' tail of each circRNA sequence.
}
\examples{
# Load a data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get genome
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)){

genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve target sequences
targets <- getCircSeqs(
    annotatedBSJs,
    gtf,
    genome)

}


}
