% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBackSplicedJunctions.R
\name{getBackSplicedJunctions}
\alias{getBackSplicedJunctions}
\title{Import detected circRNAs}
\usage{
getBackSplicedJunctions(gtf, pathToExperiment = NULL)
}
\arguments{
\item{gtf}{A data frame containing the annotation information. It can be
generated with \code{\link{formatGTF}}.}

\item{pathToExperiment}{A string containing the path to the experiment.txt
file. The file experiment.txt contains the experiment design information.
It must have at least 3 columns with headers:
\describe{
\item{label:}{(1st column) - unique names of the samples (short but informative).}
\item{fileName:}{(2nd column) - name of the input files - e.g. circRNAs_X.txt, where
x can be can be 001, 002 etc.}
\item{group:}{ (3rd column) - biological conditions - e.g. A or B; healthy or diseased
if you have only 2 conditions.}
}

By default pathToExperiment is set to NULL and the file it is searched in
the working directory. If experiment.txt is located in a different directory
then the path needs to be specified.}
}
\value{
A data frame.
}
\description{
The function getBackSplicedJunctions() reads the
circRNAs_X.txt with the detected circRNAs, adapts the content and generates
a unique data frame with all circRNAs identified by each circRNA detection
tool and the occurrences found in each sample (named as reported in the
column label in experiment.txt).
}
\examples{
check <- checkProjectFolder()

if(check == 0){
# Create gtf object
gtf <- formatGTF(pathToGTF)

# Read and adapt detected circRNAs
backSplicedJunctions<- getBackSplicedJunctions(gtf)}

}
\seealso{
\code{\link{backSplicedJunctions}} for a description of the data frame
containing back-spliced junctions coordinates.
}
