% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_connections}
\alias{plot_connections}
\title{Plot connections}
\usage{
plot_connections(
  connection_df,
  chr,
  minbp,
  maxbp,
  coaccess_cutoff = 0,
  peak_color = "#B4656F",
  connection_color = "#7F7CAF",
  connection_color_legend = TRUE,
  alpha_by_coaccess = FALSE,
  connection_width = 2,
  connection_ymax = NULL,
  gene_model = NULL,
  gene_model_color = "#81D2C7",
  gene_model_shape = c("smallArrow", "box"),
  comparison_track = NULL,
  comparison_coaccess_cutoff = 0,
  comparison_peak_color = "#B4656F",
  comparison_connection_color = "#7F7CAF",
  comparison_connection_color_legend = TRUE,
  comparison_connection_width = 2,
  comparison_ymax = NULL,
  collapseTranscripts = FALSE,
  include_axis_track = TRUE,
  return_as_list = FALSE,
  viewpoint = NULL,
  comparison_viewpoint = TRUE,
  viewpoint_color = "#F0544F",
  viewpoint_fill = "#EFD8D7",
  viewpoint_alpha = 0.5
)
}
\arguments{
\item{connection_df}{Data frame of connections, which must include the
columns 'Peak1', 'Peak2', and 'coaccess'. Generally, the output of
run_cicero or assemble_connections.}

\item{chr}{The chromosome of the region you would like to plot in the form
'chr10'.}

\item{minbp}{The base pair coordinate of the start of the region to be
plotted.}

\item{maxbp}{The base pair coordinate of the end of the region to be plotted.}

\item{coaccess_cutoff}{The minimum cicero co-accessibility score you would
like to be plotted. Default is 0.}

\item{peak_color}{Color for peak annotations - a single color, the name of a
column containing color values that correspond to Peak1, or the name of
column containing a character or factor to base peak colors on.}

\item{connection_color}{Color for connection lines. A single color, the name
of a column containing color values, or the name of a column containing a
character or factor to base connection colors on.}

\item{connection_color_legend}{Logical, should connection color legend be
shown?}

\item{alpha_by_coaccess}{Logical, should the transparency of connection
lines be scaled based on co-accessibility score?}

\item{connection_width}{Width of connection lines.}

\item{connection_ymax}{Connection y-axis height. If \code{NULL}, chosen
automatically.}

\item{gene_model}{Either \code{NULL} or a data.frame. The data.frame should
be in a form compatible with the Gviz function
\code{\link[Gviz]{GeneRegionTrack-class}} (cannot have NA as column names).}

\item{gene_model_color}{Color for gene annotations.}

\item{gene_model_shape}{Shape for gene models, passed to
\code{\link[Gviz]{GeneRegionTrack-class}}. Options described at
\code{\link[Gviz]{GeneRegionTrack-class}}.}

\item{comparison_track}{Either \code{NULL} or a data frame. If a data frame,
a second track of connections will be plotted based on this data. This
data frame has the same requirements as connection_df (Peak1, Peak2 and
coaccess columns).}

\item{comparison_coaccess_cutoff}{The minimum cicero co-accessibility score
you would like to be plotted for the comparison dataset. Default = 0.}

\item{comparison_peak_color}{Color for comparison peak annotations - a
single color, the name of a column containing color values that correspond
to Peak1, or the name of a column containing a character or factor to base
peak colors on.}

\item{comparison_connection_color}{Color for comparison connection lines. A
single color, the name of a column containing color values, or the name of
a column containing a character or factor to base connection colors on.}

\item{comparison_connection_color_legend}{Logical, should comparison
connection color legend be shown?}

\item{comparison_connection_width}{Width of comparison connection lines.}

\item{comparison_ymax}{Connection y-axis height for comparison track. If
\code{NULL}, chosen automatically.}

\item{collapseTranscripts}{Logical or character scalar. Can be one in
\code{gene}, \code{longest}, \code{shortest} or \code{meta}. Variable is
passed to the \code{\link[Gviz]{GeneRegionTrack-class}} function of Gviz.
Determines whether and how to collapse related transcripts. See Gviz
documentation for details.}

\item{include_axis_track}{Logical, should a genomic axis be plotted?}

\item{return_as_list}{Logical, if TRUE, the function will not plot, but will
return the plot components as a list. Allows user to add/customize Gviz
components and plot them separately using \code{\link[Gviz]{plotTracks}}.}

\item{viewpoint}{\code{NULL} or Coordinates in form "chr1_10000_10020". Use
viewpoint if you would like to plot cicero connections "4C-seq style".
Only connections originating in the viewpoint will be shown. Ideal for
comparisons with 4C-seq data. If comparison_viewpoint is \code{TRUE}, any
comparison track will be subsetted as well.}

\item{comparison_viewpoint}{Logical, should viewpoint apply to comparison
track as well?}

\item{viewpoint_color}{Color for the highlight border.}

\item{viewpoint_fill}{Color for the highlight fill.}

\item{viewpoint_alpha}{Alpha value for the highlight fill.}
}
\value{
A gene region plot, or list of components if return_as_list is
  \code{TRUE}.
}
\description{
Plotting function for Cicero connections. Uses \code{\link[Gviz]{plotTracks}}
as its basis
}
\examples{
  cicero_cons <- data.frame(
             Peak1 = c("chr18_10034652_10034983", "chr18_10034652_10034983",
                       "chr18_10034652_10034983", "chr18_10034652_10034983",
                       "chr18_10087586_10087901", "chr18_10120685_10127115",
                       "chr18_10097718_10097934", "chr18_10087586_10087901",
                       "chr18_10154818_10155215", "chr18_10238762_10238983",
                       "chr18_10198959_10199183", "chr18_10250985_10251585"),
             Peak2 = c("chr18_10097718_10097934", "chr18_10087586_10087901",
                       "chr18_10154818_10155215", "chr18_10238762_10238983",
                       "chr18_10198959_10199183", "chr18_10250985_10251585",
                       "chr18_10034652_10034983", "chr18_10034652_10034983",
                       "chr18_10034652_10034983", "chr18_10034652_10034983",
                       "chr18_10087586_10087901", "chr18_10120685_10127115"),
             coaccess = c(0.0051121787, 0.0016698617, 0.0006570246,
                          0.0013466927, 0.0737935011, 0.3264019452,
                          0.0051121787, 0.0016698617, 0.0006570246,
                          0.0013466927, 0.0737935011, 0.3264019452))
  plot_connections(cicero_cons, chr = "chr18",
                   minbp = 10034652,
                   maxbp = 10251585,
                   peak_color = "purple")

}
