% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCicero.R
\name{find_overlapping_ccans}
\alias{find_overlapping_ccans}
\title{Find CCANs that overlap each other in genomic coordinates}
\usage{
find_overlapping_ccans(ccan_assignments, min_overlap = 1)
}
\arguments{
\item{ccan_assignments}{A data frame where the first column is the peak and
the second is the CCAN assignment. For example, output of
\code{generate_ccans}.}

\item{min_overlap}{The minimum base pair overlap to count as overlapping.}
}
\value{
A data frame with two columns, CCAN1 and CCAN2. CCANs in this list
  are overlapping. The data frame is reciprocal (if CCAN 2 overlaps CCAN 1,
  there will be two rows, 1,2 and 2,1).
}
\description{
Find CCANs that overlap each other in genomic coordinates
}
\examples{
  ccan_df <- data.frame(peak = c("chr18_1408345_1408845", "chr18_1779830_1780330", 
                                 "chr18_1929095_1929595", "chr18_1954501_1954727",
                                 "chr18_2049865_2050884", "chr18_2083726_2084102",
                                 "chr18_2087935_2088622", "chr18_2104705_2105551",
                                 "chr18_2108641_2108907"), 
                        CCAN = c(1,2,2,2,3,3,3,3,2))
  olap_ccans <- find_overlapping_ccans(ccan_df)


}
