% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_tests.R
\name{differentialDeviations}
\alias{differentialDeviations}
\title{differentialDeviations}
\usage{
differentialDeviations(
  object,
  groups,
  alternative = c("two.sided", "less", "greater"),
  parametric = TRUE
)
}
\arguments{
\item{object}{chromVARDeviations object}

\item{groups}{either vector of groups or name of column in colData of object 
with group information}

\item{alternative}{only used if there are two groups -- two.sided or one 
sided test}

\item{parametric}{use parametric test. alternatively will use kruskal wallace}
}
\value{
data.frame with p value and adjusted p value
}
\description{
Function to see whether deviations differ between groups
}
\examples{
# Load very small example results from computeDeviations
data(mini_dev, package = "chromVAR")
difdev <- differentialDeviations(mini_dev, "Cell_Type")
}
\author{
Alicia Schep
}
