% Generated by roxygen2 (4.0.1): do not edit by hand
\name{chromDrawGR}
\alias{chromDrawGR}
\title{Function chromDrawGR uses Genomic Ranges as input data format. This R function call the main C++ function.}
\usage{
chromDrawGR(karyotypes, colors)
}
\arguments{
\item{karyotypes}{vector of the Genomic Ranges structures per karyotype.}

\item{colors}{data frame definition of coloros, containing color name and RGB of the color values.}
}
\value{
return exit state.
}
\description{
Function chromDrawGR uses Genomic Ranges as input data format. This R function call the main C++ function. If the output directory is not set, then it is use working directory for the outputs.
}
\examples{
#load package
library(GenomicRanges)

#data generating
karyotype1 <- GRanges(seqnames =Rle(c("Ack1", "Ack2"), c(5, 5)),ranges = 
IRanges(start = c(0, 400000,0,3300000,6000000,0,2500000,0,3800000,6400000), 
        end = c(400000,3300000,0,6000000,10400000,2500000,3800000,0,6400000,14800000), 
        names = c("A","B","CENTROMERE","C","D","E","F","CENTROMERE","G","H")),  
        color = c("orange","yellow","","orange","red","green","green","","red","orange"));

karyotype2 <- GRanges(seqnames =Rle(c("Ack3", "Ack4"), c(4, 4)),ranges = 
IRanges(start = c(0,0, 2400000,3500000,0,0,2400000,6700000), 
        end = c(2400000,0,3500000,12200000,2400000,0,6700000,9200000), 
        names = c("I","CENTROMERE","J","K","L","CENTROMERE","M","N")), 
        color = c("light_blue","","orange","red","pink","","red","light_blue"));

inputData <- list(karyotype1,karyotype2);

#colors generating
name <- c("yellow", "red", "blue", "violet", "orange", "green", "light_blue", "pink");
r <- c(255, 255, 0, 255, 247, 0, 0, 230);
g <- c(255, 0, 0, 0 ,148, 255, 255, 170);
b <- c(0, 0, 255, 255, 29, 0, 255, 160);
inputColors <- data.frame(name,r,g,b);

#run the function with generated data and colors
chromDrawGR(inputData,inputColors);
}


