#
# Name: chromDrawGR.R
# Description: The main controling function of chromDraw, that uses genomic ranges. Function for converting input data to the chromDraw data file.
# Author: Jan Janecka, ing  c 2014
# Contact: jan.janecka@ceitec.muni.cz
#

#' Function chromDrawGR uses Genomic Ranges as input data format. This R function call the main C++ function.
#' 
#' @param karyotypes vector of the Genomic Ranges structures per karyotype.
#' @param colors data frame definition of the coloros, containing color name and RGB of the color values.
#' @return return exit state.
chromDrawGR <- function(karyotypes, colors)
{
  if(!missing(karyotypes))
  {
    convertInputData(karyotypes); 
    OUTPUTPATH = file.path(getwd());
    INPUTPATH = file.path("data.txt");
    if(missing(colors) == TRUE)
    {
      chromDraw(argc=5, argv=c("chromDraw", "-d", INPUTPATH, "-o", OUTPUTPATH));
    }
    else
    {
      convertInputColors(colors);
      COLORPATH = file.path("colors.txt");   
      chromDraw(argc=7, argv=c("chromDraw", "-d", INPUTPATH, "-c", COLORPATH, "-o", OUTPUTPATH));
    }
  }
   
}

#converting data frame with colors to the chromDraw color file.
convertInputColors <- function(colors)
{
  fileConn <- file("colors.txt") #open file
  #lines of output file
  dataFile <- "#Colors generated by chromDraw converter";
  
  #nastaveni vypisu cisel v plnem formatu ne mocniny
  options("scipen"=100);
  
  if(length(colors) == 4)
  {
    for(i in 1:length(colors[[1]]))
    {
      #colro definition 
      line <- paste("COLOR", colors[[1]][i], colors[[2]][i], colors[[3]][i], colors[[4]][i], sep=" ");
      dataFile <- append(dataFile, line)
    }
  }
  
  writeLines(paste(dataFile), fileConn); #write to file

  close(fileConn); # close file
}

#converting vector of genomic ranges to chromDraw karyotype defitnitions. 
convertInputData <- function(karyotypes)
{
  fileConn <- file("data.txt") #open file
  #lines of output file
  dataFile <- "#Data generated by chromDraw converter";
  
  karyotypeAlias <- 1;
  
  for(d in 1:length(karyotypes))
  {
  
    #split data to separated chromosomes.
    chrs <- split(karyotypes[[d]], seqnames(karyotypes[[d]]));
  

    #karyotype defintion 
    line <- paste("KARYOTYPE", karyotypeAlias, karyotypeAlias, "BEGIN", sep=" ");
    dataFile <- append(dataFile, line);

    #nastaveni vypisu cisel v plnem formatu ne mocniny
    options("scipen"=100);
    #pruchod po jednotlivych chromosomech
    for(i in 1:length(chrs))
    {
      blockAlias <- 0;
      lineCHR <- "CHR";
      lineCHR <- paste(lineCHR, names(chrs)[i], names(chrs)[i], sep=" "); #name and alias of chromosome
      lineCHR <- paste(lineCHR, "0", sep=" "); #rozsah chroomosomu
      CHRRange <- 0;
      
      dataFileTMP <- "";
      for(item in 1:length(chrs[[i]]))
      {
	blockAlias <- blockAlias + 1
	if(paste(names(ranges(chrs[[i]])[item])) == "CENTROMERE") 
	{
	  line <- "CENTROMERE";
	  line <- paste(line, names(chrs)[i], sep=" "); #alias of chromosome
	  dataFileTMP <- append(dataFileTMP, line);
	}
	else
	{
	  line <- "BLOCK";
	  line <- paste(line, paste(names(ranges(chrs[[i]])[item])), sep=" ") #block label
	  line <- paste(line, blockAlias, sep=" "); #alias of block
	  line <- paste(line, names(chrs)[i], sep=" "); #alias of chromsome
	  line <- paste(line, paste(start(ranges(chrs[[i]])[item])), sep=" "); #sart positon of block
	  line <- paste(line, paste(end(ranges(chrs[[i]])[item])), sep=" "); #stop position of block
	  line <- paste(line, paste(mcols(chrs[[i]])$color[item], sep=" ")); #color of block
	  dataFileTMP <- append(dataFileTMP, line);
	  CHRRange <- CHRRange + (end(ranges(chrs[[i]])[item]) - start(ranges(chrs[[i]])[item]));
	}
	
      }
      lineCHR <- paste(lineCHR, CHRRange, sep=" "); #chromosome lenght
      dataFile <- append(dataFile, "\n");
      dataFile <- append(dataFile, lineCHR);
      dataFile <- append(dataFile, dataFileTMP);
      
    }

    dataFile <- append(dataFile, "\nKARYOTYPE END\n");
    karyotypeAlias <- karyotypeAlias + 1;
    
  }
  
  writeLines(paste(dataFile), fileConn); #write data to file

  close(fileConn); #close file
}