% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setup_genesets}
\alias{setup_genesets}
\title{Function to setup genesets}
\usage{
setup_genesets(gs_codes, ldef_obj, genome, min_geneset_size, max_geneset_size)
}
\arguments{
\item{gs_codes}{A character vector of geneset databases to be tested for
enrichment. See \code{supported_genesets()}. Alternately, a file path to a
a tab-delimited text file with header and first column being the geneset ID
or name, and the second column being Entrez Gene IDs.}

\item{ldef_obj}{A \code{LocusDefinition} object to use for filtering gene sets
based on which genes are defined in the locus defintion.}

\item{genome}{One of the \code{supported_genomes()}.}

\item{min_geneset_size}{Sets the minimum number of genes a gene set may have
to be considered for enrichment testing.}

\item{max_geneset_size}{Sets the maximum number of genes a gene set may have
to be considered for enrichment testing.}
}
\value{
A list with components consisting of \code{GeneSet} objects for each
of the elements of \code{genesets}. NOTE: Custom genesets must be run separately
from built in gene sets.
}
\description{
Function to setup genesets
}
