% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaks_per_gene.R
\name{calc_peak_gene_overlap}
\alias{calc_peak_gene_overlap}
\title{Add peak overlap and ratio to result of \code{num_peaks_per_gene()}}
\usage{
calc_peak_gene_overlap(assigned_peaks, ppg)
}
\arguments{
\item{assigned_peaks}{A \code{data.frame} resulting from \code{assign_peak_segments()}.}

\item{ppg}{The aggregated peak assignments over \code{gene_id} from \code{num_peaks_per_gene()}.}
}
\value{
A \code{data.frame} with columns \code{gene_id, length, log10_length, num_peaks, peak, peak_overlap, ratio}. The result is used directly in the gene set enrichment tests in \code{chipenrich()} when \code{method = 'broadenrich'}.
}
\description{
In particular, for \code{method = 'broadenrich'} in \code{chipenrich()}, when using \code{assign_peak_segments()}. This function will add aggregated \code{peak_overlap} (in base pairs) and \code{ratio} (relative to \code{length}) columns to the result of \code{num_peaks_per_gene()} so the right data is present for the \code{method = 'broadenrich'} model.
}
\details{
Typically, this function will not be used alone, but inside \code{chipenrich()} with \code{method = 'broadenrich'}.
}
\examples{

data('locusdef.hg19.nearest_tss', package = 'chipenrich.data')
data('tss.hg19', package = 'chipenrich.data')

file = system.file('extdata', 'test_assign.bed', package = 'chipenrich')
peaks = read_bed(file)

assigned_peaks = assign_peak_segments(
	peaks = peaks,
	locusdef = locusdef.hg19.nearest_tss)

ppg = num_peaks_per_gene(
	assigned_peaks = assigned_peaks,
	locusdef = locusdef.hg19.nearest_tss,
	mappa = NULL)

ppg = calc_peak_gene_overlap(
	assigned_peaks = assigned_peaks,
	ppg = ppg)

}
