% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_peaks.R
\name{assign_peaks}
\alias{assign_peaks}
\title{Assign peak midpoints to defined gene loci.}
\usage{
assign_peaks(peaks, locusdef, tss, weighting = NULL)
}
\arguments{
\item{peaks}{A \code{GRanges} object representing regions to be used for enrichment.}

\item{locusdef}{A locus definition object from \code{chipenrich.data}.}

\item{tss}{A \code{GRanges} object representing the TSSs for the genome build. Includes \code{mcols} for Entrez Gene ID \code{gene_id} and gene symbol \code{symbol}.}

\item{weighting}{A string defining what weighting option they want. Current options are 'multiAssign', 'signalValue', and 'logSignal Value'. Default is NULL.}
}
\value{
A \code{data.frame} with columns for \code{peak_id, chr, peak_start, peak_end, gene_locus_start, gene_locus_end, gene_id, nearest_tss, nearest_tss_gene, dist_to_tss, nearest_tss_gene_strand}. The result is used in \code{num_peaks_per_gene()}.
}
\description{
Determine the midpoints of a set of input regions \code{peaks} and the overlap of the midpoints with a given locus definition \code{locusdef}. Also report the TSS that is nearest each region (peak) overlapping a defined locus and its distance.
}
\details{
Typically, this function will not be used alone, but inside \code{chipenrich()}.
}
\examples{

data('locusdef.hg19.nearest_tss', package = 'chipenrich.data')
data('tss.hg19', package = 'chipenrich.data')

file = system.file('extdata', 'test_assign.bed', package = 'chipenrich')
peaks = read_bed(file)

assigned_peaks = assign_peaks(
	peaks = peaks,
	locusdef = locusdef.hg19.nearest_tss,
	tss = tss.hg19)

}
