% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_soapfuse.R
\name{import_soapfuse}
\alias{import_soapfuse}
\title{Import results from a SOAPfuse run into a list of Fusion objects.}
\usage{
import_soapfuse(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the SOAPfuse
final-list-candidate-fusion-genes.txt results file.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from a SOAPfuse run, typically from
a final.Fusion.specific.for.genes file, into a list of Fusion objects.
}
\examples{
soapfuse833ke <- system.file(
  "extdata",
  "soapfuse_833ke_final.Fusion.specific.for.genes",
  package = "chimeraviz")
fusions <- import_soapfuse(soapfuse833ke, "hg19", 3)
# This should import a list of 3 fusions described in Fusion objects.

}
