% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_infusion.R
\name{import_infusion}
\alias{import_infusion}
\title{Import results from an InFusion run into a list of Fusion objects.}
\usage{
import_infusion(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the jaffa_results.csv file.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from an InFusion run nto a list of Fusion
objects.
}
\examples{
infusionData <- system.file(
  "extdata",
  "infusion_fusions.txt",
  package = "chimeraviz")
fusions <- import_infusion(infusionData, "hg19", 3)
# This should import a list of 3 fusions described in Fusion objects.

}
