% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_fusioncatcher.R
\name{import_fusioncatcher}
\alias{import_fusioncatcher}
\title{Import results from a Fusioncatcher run into a list of Fusion objects.}
\usage{
import_fusioncatcher(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the Fusioncatcher
final-list-candidate-fusion-genes.txt results file.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from a Fusioncatcher run, typically from
a final-list-candidate-fusion-genes.txt file, into a list of Fusion objects.
}
\examples{
fusioncatcher833ke <- system.file(
  "extdata",
  "fusioncatcher_833ke_final-list-candidate-fusion-genes.txt",
  package = "chimeraviz")
fusions <- import_fusioncatcher(fusioncatcher833ke, "hg38", 3)
# This should import a list of 3 fusions described in Fusion objects.

}
