% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{fusion_spanning_reads_count}
\alias{fusion_spanning_reads_count}
\alias{fusion_spanning_reads_count,Fusion-method}
\title{Get the spanning reads count from a Fusion object}
\usage{
fusion_spanning_reads_count(x)

\S4method{fusion_spanning_reads_count}{Fusion}(x)
}
\arguments{
\item{x}{The Fusion object you wish to retrieve the spanning reads count for.}
}
\value{
The Fusion spanning reads count.
}
\description{
This getter retrieves the spanning reads count from a Fusion object
}
\examples{
# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- fusions[[1]]
# Get the spanning reads count
fusion_spanning_reads_count(fusion)

}
