% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_circle.R
\name{chimeraviz-internals-fusions_to_link_data}
\alias{chimeraviz-internals-fusions_to_link_data}
\alias{.fusions_to_link_data}
\title{Create link data for RCircos from the given fusions.}
\usage{
.fusions_to_link_data(fusion_list, min_link_width = 1, max_link_widt = 10)
}
\arguments{
\item{fusion_list}{A list of Fusion objects.}

\item{min_link_width}{The minimum link line width. Default = 1}

\item{max_link_widt}{The maximum link line width. Default = 10}
}
\value{
A data frame with fusion link data compatible with RCircos::RCircos.Link.Plot()

# @examples # Apparently examples shouldn't be set on private functions
defuse833ke <- system.file("extdata", "defuse_833ke_results.filtered.tsv", package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 3)
linkData <- chimeraviz::.fusions_to_link_data(fusions)
# This linkData can be used with RCircos::RCircos.Link.Plot()
}
\description{
This function takes a list of Fusion objects and creates a data frame in the
format that RCircos::RCircos.Link.Plot() expects for link data.
}
