% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DelayedUnaryIsoOpStack.R
\name{saveDelayedObject,DelayedUnaryIsoOpStack-method}
\alias{saveDelayedObject,DelayedUnaryIsoOpStack-method}
\title{Saving a DelayedUnaryIsoOpStack}
\usage{
\S4method{saveDelayedObject}{DelayedUnaryIsoOpStack}(x, file, name)
}
\arguments{
\item{x}{A \linkS4class{DelayedUnaryIsoOpStack} object.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of the DelayedUnaryIsoOpStack.
}
\description{
Save a \linkS4class{DelayedUnaryIsoOpStack} object into a HDF5 file.
See the \dQuote{Unary ...} operations at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
X <- DelayedArray(matrix(runif(100), ncol=20))
Y <- log2(X + 10)
temp <- tempfile(fileext=".h5")
saveDelayed(Y, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
