% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{sce_de}
\alias{sce_de}
\title{Run Differential Expression}
\usage{
sce_de(
  object,
  cluster1,
  cluster2,
  resolution = 0.2,
  diffex_scheme = "louvain",
  featureType = "gene",
  tests = c("t", "wilcox", "bimod")
)
}
\arguments{
\item{object}{a SingleCellExperiment object}

\item{cluster1}{cluster 1}

\item{cluster2}{cluster 2}

\item{resolution}{resolution}

\item{diffex_scheme}{scheme for differential expression}

\item{featureType}{gene or transcript}

\item{tests}{t, wilcox, or bimod}
}
\value{
a dataframe with differential expression information
}
\description{
Run Differential Expression
}
\examples{
data("tiny_sce")
sce_de(tiny_sce, 
colnames(tiny_sce)[1:100], 
colnames(tiny_sce)[101:200], 
diffex_scheme = "custom")

}
