% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_transcript_composition}
\alias{plot_transcript_composition}
\title{Plot Transcript Composition}
\usage{
plot_transcript_composition(
  object,
  gene_symbol,
  group.by = "batch",
  standardize = FALSE,
  drop_zero = FALSE
)
}
\arguments{
\item{object}{A object}

\item{gene_symbol}{Gene symbol of gene of interest}

\item{group.by}{Name of one or more metadata columns to annotate columns by
(for example, orig.ident)}

\item{standardize}{whether to standardize values}

\item{drop_zero}{Drop zero values}
}
\value{
a stacked barplot of transcript counts
}
\description{
plot the proportion of reads of a given gene map to each transcript
}
\examples{

data(tiny_sce)
plot_transcript_composition(tiny_sce, "NRL")

}
